#!/bin/sh

if [ "z$1" = "z" ]; then
  echo "usage: $0 miniinst.iso"
  exit 1
fi

if ! [ `id -g` = "0" ]; then
  echo "You must be root to run this."
  exit 1
fi

mkdir dist
rm -f dist.mounted
case "`uname -s`" in
  FreeBSD)
    case "`uname -r`" in
      4*) vnconfig vn0c $1
          mount -t cd9660 /dev/vn0c dist
          touch dist.mounted;;
      5*) mdconfig -a -t vnode -f $1
          mount -t cd9660 /dev/md0 dist
          touch dist.mounted;;
    esac;;
  Linux)
    mount -t iso9660 -o loop $1 dist
    touch dist.mounted;;
esac

if ! [ -e dist.mounted ]; then
  echo "Cannot unmount $1 from dist automatically."
  echo "Do it yourself."
  sh -i
  touch dist.mounted
fi

mkdir mfs && chown root:wheel mfs
cat dist/base/base.?? | tar --unlink -xpzf - -C mfs
cat dist/crypto/crypto.?? | tar --unlink -xpzf - -C mfs

case "`uname -s`" in
  FreeBSD)
    case "`uname -r`" in
      4*) umount dist
          vnconfig -u vn0c
          rm dist.mounted;;
      5*) umount dist
          mdconfig -d -u 0
          rm dist.mounted;;
    esac;;
  Linux)
    umount dist
    rm dist.mounted;;
esac

if [ -e dist.mounted ]; then
  echo "Cannot unmount $1 from dist automatically."
  echo "Do it yourself."
  sh -i
  rm dist.mounted
fi
rmdir dist

rm -rf mfs/rescue mfs/usr/include
for x in c++ g++ CC gcc cc yacc byacc f77 addr2line	\
	ar as gasp gdb gdbreplay ld nm objcopy objdump	\
	ranlib readelf size strip; do			\
	rm -f mfs/usr/bin/$x;				\
done
rm -f mfs/usr/lib/*.a
rm -f mfs/usr/libexec/cc1* mfs/usr/libexec/f771

mkdir mfs/stand mfs/etc/rc.conf.d
cp mdinit.conf mfs/etc/rc.conf.d/mdinit
cp initconf.conf mfs/etc/rc.conf.d/initconf
cp mdinit initconf mfs/etc/rc.d
chmod 555 mfs/etc/rc.d/mdinit mfs/etc/rc.d/initconf
echo "/dev/md0 / ufs rw 0 0" > mfs/etc/fstab

( cd mfs && tar -cf - usr | gzip -9 > usr.tgz )
cp mfs/usr/bin/tar mfs/usr/bin/gzip mfs/stand
rm -rf mfs/usr && mkdir mfs/usr

mkdir disk && chown root:wheel disk
rm -f mfs/boot/kernel/kernel.debug
cp -rp mfs/boot disk
rm -rf mfs/boot/kernel

tar -xzf makefs-20031226.tar.gz
( cd makefs-20031226 && sh build.sh )
MAKEFS=makefs-20031226/netbsdsrc/tools/makefs/makefs

${MAKEFS} -b 8% -f 8% disk/mfsroot mfs
rm -rf mfs
gzip -9 disk/mfsroot
gzip -9 disk/boot/kernel/kernel
cp loader.conf disk/boot/

${MAKEFS} -s 81920b disk.img disk
rm -rf disk
dd if=label.40M of=disk.img bs=8192 count=1 conv=notrunc

rm -rf makefs-20031226
